<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Place extends Model 
{

    protected $table = 'places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function event()
    {
        return $this->belongsTo('App\Model\Event');
    }

    public function customer()
    {
        return $this->belongsTo('App\Model\Customer');
    }

    public function races()
    {
        return $this->hasMany('App\Model\Act');
    }

}